;FILE: TXTEST.ASM, Last edition: 24th of August 1995
;simple transmitter test to determine the transmited audio passband
;(c) 1995 Pawel Jalocha, SP9VRC,
;e-mail: jalocha@chopin.ifj.edu.pl, sp9vrc@gw.sp9kby.ampr.org
;

;*************************************************************************
;compile-time constants

EVM56K  equ 0           ;0 => DSPCARD4
                        ;1 => EVM56002

SampleFreq equ 8000.0

TxAttenuate     equ 20.0        ;output attenuation factor

BufLen          equ 16          ;CODEC's buffer size

RightChannel    equ 0

;*************************************************************************

        scsjmp short

        nolist
	include 'leonid'
	list

;Some macros

      if RightChannel
PTT     macro mode      ;PTT line: clr/set/chg
        b\mode #4,X:$FFE4
        endm
      else
PTT     macro mode      ;PTT line: clr/set/chg
        b\mode #0,X:$FFE4
;      b\mode #3,X:$FFE4       ;*** DEBUG ***
        endm
      endif

;*************************************************************************
;The actuall code (internal/external program RAM)

        LOMEM P:$0000
        HIMEM P:$1FFF

        org p:user_code

        ori #%00000100,omr      ;enable the sine ROM table

        move #Buffer+2,r7
        move #BufLen*4-1,m7

        move #Buffer,r2
        move #4-1,n2
        move #BufLen*4-1,m2

        ctrlcd 1,r2,BufLen,LINEI,0.0,0.0,LINEO|HEADP,TxAttenuate,TxAttenuate
        opencd SampleFreq/1000.0,HPF

; wait for one complete block
ProcessLoop
        move #>1,a
        jsr <WaitSampleBlock

        move X:<CarPhase,x0     ;get the receiver NCO's carrier phase
        move X:<CarFreq,a       ;advance the phase
        add x0,a
        move a1,X:<CarPhase
        jsr <IQ                 ;compute I and Q (modifies a,b,x,y,r0,m0,n0)

        move (r2)+
        move a,Y:(r2)+
        move a,Y:(r2)+
        move (r2)+

ReadInput
        lookc 0                 ;any characters on the serial port ?
        jcs <ProcessLoop        ;jump if none

        move #>'p',a
        cmp x0,a #>'>',a        ; 'p' pressed ?
        jeq <PTTchg
        cmp x0,a #>'<',a        ; '>' pressed ?
        jeq <Step1Up
        cmp x0,a #>']',a        ; '<' pressed ?
        jeq <Step1Down
        cmp x0,a #>'[',a
        jeq <Step2Up
        cmp x0,a #>'}',a
        jeq <Step2Down
        cmp x0,a #>'{',a
        jeq <Step3Up
        cmp x0,a
        jeq <Step3Down

        jmp <ProcessLoop

PTTchg  PTT chg
        jmp <ReadInput

Step1Up move X:<CarFreq,a
        move X:<CarStep1,x0
        add x0,a
        move a,X:<CarFreq
        jmp <PrintFreq
Step1Down
        move X:<CarFreq,a
        move X:<CarStep1,x0
        sub x0,a
        move a,X:<CarFreq
        jmp <PrintFreq

Step2Up move X:<CarFreq,a
        move X:<CarStep2,x0
        add x0,a
        move a,X:<CarFreq
        jmp <PrintFreq
Step2Down
        move X:<CarFreq,a
        move X:<CarStep2,x0
        sub x0,a
        move a,X:<CarFreq
        jmp <PrintFreq

Step3Up move X:<CarFreq,a
        move X:<CarStep3,x0
        add x0,a
        move a,X:<CarFreq
        jmp <PrintFreq
Step3Down
        move X:<CarFreq,a
        move X:<CarStep3,x0
        sub x0,a
        move a,X:<CarFreq
        jmp <PrintFreq

PrintFreq
        move X:<CarFreq,x0
        move #SampleFreq/2.0/10000.0,x1
        mpyr x0,x1,a
        move #4,n0
        jsr <PrintNum
        move #>' ',x0
        putc
        move #>'H',x0
        putc
        move #>'z',x0
        putc
        move #>13,x0
        putc
        jmp <ReadInput

;******************************************************************************

CheckSampleBlock        ;a = how many samples we want
        asl a           ;r2 = where we wait for the block to start
        asl a #>1,x1
        add x1,a
        move a,x1
CheckSampleBlock_1
        move r7,a
        move r2,x0
        sub x0,a
        jpl <CheckSample_cmp
        move #>BufLen*4,x0
        add x0,a        ; buffer wraparound, rp - wp + lenght > threshold
CheckSample_cmp
        cmp x1,a        ; wp - rp > threshold
        rts             ;on output: a,x0,x1 are modified
                        ;If carry=0 => we are sure that:
                        ;1. there are at least A new input samples at X:(r2)
                        ;   to be read
                        ;2. there are at least A locations at Y:(r2) to
                        ;   be written


WaitSampleBlock         ;wait for a block of samples from the CODEC
                        ;made from the LEONID's "waitblk" macro
                        ;on input: a = how many samples we want
                        ;          r2 = where the block starts
        jsr <CheckSampleBlock
        jcc <WaitSample_ret
WaitSample_loop
        wait            ;wait until an interrupt comes
        jsr <CheckSampleBlock_1
        jcs <WaitSample_loop
WaitSample_ret
        rts             ;on output: a,x0,x1 are modified
                        ;We are sure that:
                        ;1. there are at least A new input samples at X:(r2)
                        ;   to be read
                        ;2. there are at least A locations at Y:(r2) to
                        ;   be written


PI      equ     3.14159265358979323846

;this routine computes a cosine/sine pair using the sine ROM
;with a second order (linear+quadrature) approximation between table points
IQ                              ;x0 = angle ( -1 = -PI, +1 = +PI)
;        ori #%00000100,omr      ;enable the sine ROM table
        move #>$80,x1   ;shift out 8 most significant bits
        mpy x0,x1,a  #>$FF,x0
        move x0,m0
        and x0,a     #>$100,x0
        or x0,a      #<$40,n0
        move a1,r0      ;put the 8 most significant bits into r0 with offset = $100
        move a0,y0      ;save the remaining bits in y0
        jclr #23,y0,SinTable_lev2
          move (r0)+
SinTable_lev2
        move Y:(r0+n0),x0       ;x0 = coarse cosine
        move Y:(r0),x1          ;x1 = coarse sine
        mpyr x1,y0,a  #PI/256.0,y1
        tfr x0,a  a,x1
        macr -x1,y1,a           ;a = fine cosine
        mpyr x0,y0,b  Y:(r0),x1
;        andi #%11111011,omr     ;disable the sine ROM table
        tfr x1,b  b,x1
        macr x1,y1,b  #PI*PI/2.0/65536.0,y1  ;b = fine sine
        mpyr y0,y0,a  a,x0
        move a,y0
        mpyr y0,y1,a
        tfr x0,a  a,y1
        macr -x0,y1,a  b,x1     ;a = super fine cosine
        macr -x1,y1,b           ;b = super fine sine
        rts                     ;x,y are modified
                                ;r0,m0,n0 are modified
                                ;maximum error is about 0.7E-6
                                ;execution time 4+64+4 clock cycles
                                ;including "jsr <IQ_lev2" and "rts"

PrintNum                        ;print a number in a decimal form
                                ;on the serial output
        .loop n0
          asl a
          tfr a,b
          asl a
          asl a
          add b,a
          asl a a1,X:<Num
          move a2,x0
          move #>'0',a
          add x0,a
          move a,x0
          putc
          bclr #23,X:<Num
          move X:<Num,a
        .endl
        rts

;******************************************************************************
;Internal data RAM

        LOMEM X:$0000,Y:$0000,L:$0000
        HIMEM X:$00FF,Y:$00FF,L:$00FF

        org X:user_data

CarFreq  dc 1000.0*2.0/SampleFreq
CarPhase dc 0
CarStep1 dc 1.0*2.0/SampleFreq
CarStep2 dc 10.0*2.0/SampleFreq
CarStep3 dc 100.0*2.0/SampleFreq

Num      ds 1

;*************************************************************************
;External data RAM

        if EVM56K
          LOMEM X:$2000,Y:$0100,L:$2000
          HIMEM X:$3FFF,Y:$3FFF,L:$3FFF
        else
          LOMEM X:$0100,Y:$0100,L:$0100
          HIMEM X:$1FFF,Y:$3FFF,L:$1FFF
        endif

      if EVM56K
        org L:$2000
      else
        org L:$200
      endif

Buffer  dsm BufLen*4

;*************************************************************************

        end

